/*---------------------------------------------------------------------------*\

    FILE....: FIFO.H
    TYPE....: C++ Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97

    Functions used to implement First In First Out (FIFO) queues of 16 bit
    words.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __FIFO__
#define __FIFO__

#include "contypes.h"

/*--------------------------------------------------------------------------*\

				 DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK		0	// no problems 				
#define	FIFO_FULL	1	// FIFO full				
#define	FIFO_EMPTY	2	// FIFO empty				

/*-------------------------------------------------------------------------*\

				CLASS

\*-------------------------------------------------------------------------*/

class FifoData;

class Fifo {
	FifoData	*d;
public:
	Fifo(USHORT size);
	~Fifo();
	int Write(word *buf, USHORT size);
	int Read(word *buf, USHORT size);
	void HowFull(USHORT *words);
};

#endif	/* #ifndef __FIFO__	*/

